#ifndef OHIPHANDLE_H__
#define OHIPHANDLE_H__

enum
{
	HIP_POS                 = 10000,
    LEFT_HIP_JOINT          = 10001,
    RIGHT_HIP_JOINT         = 10002,
    LOWER_HIP_TARGET        = 10003,
    X_AXIS_SYMMETRY         = 10004,
    LEFT_KNEE_TARGET        = 10005,
    RIGHT_KNEE_TARGET       = 10006,
    HIPHANDLE_PARENT        = 10007,
    HIPHANDLE_NULL          = 10008,
    CONSTRAINT_OK           = 10009,
    SAVE_RELATIVE_MATRIX    = 10010,
    DELETE_RELATIVE_MATRIX  = 10011,
    RIG_MAT                 = 10012,
    OLD_RIG_MAT             = 10013,
    MODE                    = 10014,
    MODE_SETUP = 0,
    MODE_SETUP_SYMMETRY = 1,
    MODE_IK = 2,
    MODE_WALK = 3,
    MODE_MOCAP = 4,
    LEFT_ANKLE              = 10015,
    LEFT_FOOT               = 10016,
    LEFT_FOOT_ROLL          = 10017,
    LEFT_TOES               = 10018,
    LEFT_TOES_TIP           = 10020,
    LEFT_FOOT_O_BANK        = 10021,
    LEFT_FOOT_I_BANK        = 10022,
    LEFT_FOOT_BANKING       = 10023,
    FRONTAL_HIP_TARGET      = 10024,

    RIGHT_ANKLE              = 10025,
    RIGHT_FOOT               = 10026,
    RIGHT_FOOT_ROLL          = 10027,
    RIGHT_TOES               = 10028,
    WALK_IN_PLACE            = 10029,
    RIGHT_TOES_TIP           = 10030,
    RIGHT_FOOT_O_BANK        = 10031,
    RIGHT_FOOT_I_BANK        = 10032,
    RIGHT_FOOT_BANKING       = 10033,
    
    LOCAL_SPINESTART_POS    = 10034,

    LEFT_FOOT_DIRECTION      = 10035,
    RIGHT_FOOT_DIRECTION     = 10036,
    HEAD_DIRECTION          = 10037,
    HEAD_JOINT              = 10038,
    HEAD_END_JOINT          = 10039,
    LEFT_KNEE_PARENT        = 10040,
    RIGHT_KNEE_PARENT       = 10041,
    LEFT_ANKLE_PARENT       = 10042,
    RIGHT_ANKLE_PARENT      = 10043,
    LEFT_TOES_PARENT        = 10044,
    RIGHT_TOES_PARENT       = 10045,
    LEFT_TOES_TIP_PARENT    = 10046,
    RIGHT_TOES_TIP_PARENT   = 10047,
    LEFT_THIGH_PARENT       = 10050,
    RIGHT_THIGH_PARENT      = 10051,
    
    LEFT_ELLBOW_DIRECTION   = 10052,
    RIGHT_ELLBOW_DIRECTION  = 10053,
    LEFT_KNEE_DIRECTION     = 10054,
    RIGHT_KNEE_DIRECTION    = 10055,
    
    HEAD_PARENT             = 10056,
    HEAD_END_PARENT         = 10057,
    
    PARENTS_DIALOG_GROUP    = 10058,
    HANDLES_DIALOG_GROUP    = 10059,
    CREATE_IK_CONSTRAINTS   = 10060,
    IK_CONSTRAINTS_GROUP    = 10061,
    
    OLD_TIME_VALUE          = 10062,
    OLD_TIME                = 10063,
    NEW_TIME                = 10064,
    VORSCHUB_SPEICHER       = 10065,
    BASIC_SETTINGS_GROUP    = 10066,
    MOTION_DESIGNER_GROUP   = 10067,
    CURVES_GROUP            = 10068,
    STATIC_POSES_GROUP      = 10069,
    
    LEFT_SHOULDER_JOINT     = 10070,
    RIGHT_SHOULDER_JOINT    = 10071,
    LEFT_SHOULDER_PARENT    = 10072,
    RIGHT_SHOULDER_PARENT   = 10073,
    LAST_CHEST_JOINT        = 10074,
    LAST_CHEST_PARENT       = 10075,
    SIT_DOWN_SLIDER         = 10076,
    SIT_HIP_CURVE_POS_Y     = 10077,
    SIT_HIP_CURVE_POS_Z     = 10078,
    SIT_HIP_CURVE_DIR_Z     = 10079,
    SIT_CHEST_CURVE_DIR_Z   = 10080,
    SIT_POSITION            = 10081,
    SIT_ELLBOW_POS_X        = 10082,
    SIT_ELLBOW_POS_Z        = 10083,
    SIT_ELLBOW_DIR_X        = 10084,
    SIT_ELLBOW_DIR_Y        = 10085,
    SIT_ELLBOW_DIR_Z        = 10086,
    SIT_WRIST_DIR_X         = 10087,
    SIT_WRIST_DIR_Y         = 10088,
    SIT_WRIST_DELTA_DIR     = 10089,

    SIT_WRIST_POS_X         = 10090,
    SIT_WRIST_POS_Y         = 10091,
    SIT_WRIST_POS_Z         = 10092,
    SIT_WRIST_DELTA_POS     = 10093,
    SIT_ELLBOW_DELTA_POS    = 10094,
    SIT_ELLBOW_DELTA_DIR    = 10095,
    
    SPINE_Z_POS_CORRECTION  = 10096,

    FRONTAL_CHEST_TARGET    = 10100,
    SIDE_CHEST_TARGET       = 10101,
    LOCAL_LEFT_HIP          = 10110,
    LOCAL_RIGHT_HIP         = 10111,
    LOCAL_LEFT_SHOULDER     = 10112,
    LOCAL_RIGHT_SHOULDER    = 10113,

    LEFT_FOREARM_PARENT     = 10115,
    RIGHT_FOREARM_PARENT    = 10116,
    LEFT_HAND_PARENT        = 10117,
    RIGHT_HAND_PARENT       = 10118,
    LEFT_ELLBOW_TARGET      = 10119,
    RIGHT_ELLBOW_TARGET     = 10120,
    LEFT_HAND_JOINT         = 10121,
    RIGHT_HAND_JOINT        = 10122,
    LEFT_FOREARM_DIRECTION  = 10123,
    RIGHT_FOREARM_DIRECTION = 10124,
    LEFT_HAND_DIRECTION     = 10125,
    RIGHT_HAND_DIRECTION    = 10126,
    LEFT_FOREARM_TWIST_PARENT   = 10127,
    RIGHT_FOREARM_TWIST_PARENT  = 10128,
    FIRST_NECK_JOINT        = 10200,
    FIRST_NECK_PARENT       = 10201,
    LEFT_COLLAR_POS         = 10202,
    RIGHT_COLLAR_POS        = 10203,
    LEFT_COLLAR_PARENT      = 10204,
    RIGHT_COLLAR_PARENT     = 10205,
    LOCAL_LEFT_COLLAR       = 10206,
    LOCAL_RIGHT_COLLAR      = 10207,
    LOCAL_NECK_POS          = 10208,
    
    RIGHT_SHOULDER_HANDLE   = 10210,
    LEFT_SHOULDER_HANDLE    = 10211,
    LEFT_ANKLE_HANDLE       = 10212,
    RIGHT_ANKLE_HANDLE      = 10213,
    LEFT_TOES_HANDLE        = 10214,
    RIGHT_TOES_HANDLE       = 10215,
    LEFT_TOESTIP_HANDLE     = 10216,
    RIGHT_TOESTIP_HANDLE    = 10217,
    
    LEFT_HAND_TIP_PARENT   = 10218,
    RIGHT_HAND_TIP_PARENT  = 10219,
    
    FIRST_SPINE_JOINT       = 10223,
    LAST_SPINE_JOINT        = 10224,
    FIRST_SPINE_PARENT      = 10225,
    LAST_SPINE_PARENT       = 10226,
    
    GLOBAL_IK_STRENGTH        = 10229,
    IK_HIP_ANFASSER_LINK      = 10230,
    IK_LEFT_KNEE_LINK         = 10231,
    IK_RIGHT_KNEE_LINK        = 10232,
    IK_LEFT_FOOT_LINK         = 10233,
    IK_RIGHT_FOOT_LINK        = 10234,
    IK_CHEST_ANFASSER_LINK    = 10235,
    IK_HEAD_LINK              = 10236,
    IK_LEFT_ELLBOW_LINK       = 10237,
    IK_RIGHT_ELLBOW_LINK      = 10238,
    IK_LEFT_HAND_LINK         = 10239,
    IK_RIGHT_HAND_LINK        = 10240,
    
    CREATE_JOINTS           = 10250,
    
    RELATIVE_HIP_MATRIX     = 10300,
    RELATIVE_L_THIGH_MATRIX = 10301,
    RELATIVE_R_THIGH_MATRIX = 10302,
    RELATIVE_L_FOOT_MATRIX  = 10303,
    RELATIVE_R_FOOT_MATRIX  = 10304,
    RELATIVE_L_TOES_MATRIX  = 10305,
    RELATIVE_R_TOES_MATRIX  = 10306,
    RELATIVE_L_SHIN_MATRIX  = 10307,
    RELATIVE_R_SHIN_MATRIX  = 10308,
    RELATIVE_CHEST_MATRIX   = 10309,
    RELATIVE_L_SHOULDER_MATRIX  = 10310,
    RELATIVE_R_SHOULDER_MATRIX  = 10311,
    RELATIVE_L_FOREARM_MATRIX   = 10312,
    RELATIVE_R_FOREARM_MATRIX   = 10313,
    RELATIVE_L_HAND_MATRIX  = 10314,
    RELATIVE_R_HAND_MATRIX  = 10315,
    RELATIVE_NECK_MATRIX    = 10316,
    RELATIVE_HEAD_MATRIX    = 10317,
    RELATIVE_L_CLAVICLE_MATRIX  = 10318,
    RELATIVE_R_CLAVICLE_MATRIX  = 10319,
    RELATIVE_L_FOREARM_TWIST_MATRIX = 10320,
    RELATIVE_R_FOREARM_TWIST_MATRIX = 10321,
    RELATIVE_SPINE1_MATRIX = 10322,
    RELATIVE_SPINE2_MATRIX = 10323,
    
    ABSOLUTE_HIP_MATRIX     = 10350,
    ABSOLUTE_L_THIGH_MATRIX = 10351,
    ABSOLUTE_R_THIGH_MATRIX = 10352,
    ABSOLUTE_L_FOOT_MATRIX  = 10353,
    ABSOLUTE_R_FOOT_MATRIX  = 10354,
    ABSOLUTE_L_TOES_MATRIX  = 10355,
    ABSOLUTE_R_TOES_MATRIX  = 10356,
    ABSOLUTE_L_SHIN_MATRIX  = 10357,
    ABSOLUTE_R_SHIN_MATRIX  = 10358,
    ABSOLUTE_CHEST_MATRIX   = 10359,
    ABSOLUTE_L_SHOULDER_MATRIX  = 10360,
    ABSOLUTE_R_SHOULDER_MATRIX  = 10361,
    ABSOLUTE_L_FOREARM_MATRIX   = 10362,
    ABSOLUTE_R_FOREARM_MATRIX   = 10363,
    ABSOLUTE_L_HAND_MATRIX  = 10364,
    ABSOLUTE_R_HAND_MATRIX  = 10365,
    ABSOLUTE_NECK_MATRIX    = 10366,
    ABSOLUTE_HEAD_MATRIX    = 10367,
    ABSOLUTE_L_CLAVICLE_MATRIX  = 10368,
    ABSOLUTE_R_CLAVICLE_MATRIX  = 10369,
    ABSOLUTE_L_FOREARM_TWIST_MATRIX = 10370,
    ABSOLUTE_R_FOREARM_TWIST_MATRIX = 10371,
    ABSOLUTE_SPINE1_MATRIX = 10372,
    ABSOLUTE_SPINE2_MATRIX = 10373,
    
    LAENGE_OBERSCHENKEL_L   = 10400,
    LAENGE_UNTERSCHENKEL_L  = 10401,
    LAENGE_OBERSCHENKEL_R   = 10402,
    LAENGE_UNTERSCHENKEL_R  = 10403,
    LAENGE_OBERARM_L   = 10404,
    LAENGE_UNTERARM_L  = 10405,
    LAENGE_OBERARM_R   = 10406,
    LAENGE_UNTERARM_R  = 10407,
    LAENGE_ANKLE_L = 10408,
    LAENGE_ANKLE_R = 10409,
    LAENGE_UNTERARM_TWIST_L = 10410,
    LAENGE_UNTERARM_TWIST_R = 10411,
    
    DYNAMIC_MORPH   = 10497,
    SPEED_MORPH = 10498,
    TIME_OFFSET = 10499,
    WALK_HIP_POS    = 10500,
    WALK_SLOW_HIP_POS_Y = 10501,
    WALK_SLOW_HIP_POS_X = 10502,
    WALK_SLOW_HIP_POS_Z = 10503,
    WALK_FAST_HIP_POS_Y = 10504,
    WALK_FAST_HIP_POS_X = 10505,
    WALK_FAST_HIP_POS_Z = 10506,
    AMPLITUDE_HIP_POS = 10507,
    AMPLITUDE_HIP_ROT = 10508,
    WALK_HIP_ROT = 10509,
    WALK_SLOW_HIP_ROT_Y = 10510,
    WALK_SLOW_HIP_ROT_X = 10511,
    WALK_SLOW_HIP_ROT_Z = 10512,
    WALK_FAST_HIP_ROT_Y = 10513,
    WALK_FAST_HIP_ROT_X = 10514,
    WALK_FAST_HIP_ROT_Z = 10515,
    WALK_SLOW_FOOT_POS_X = 10516,
    WALK_SLOW_FOOT_POS_Y = 10517,
    WALK_SLOW_FOOT_POS_Z = 10518,
    WALK_SLOW_FOOT_DIR_X = 10519,
    WALK_SLOW_FOOT_DIR_Y = 10520,
    WALK_FAST_FOOT_POS_X = 10521,
    WALK_FAST_FOOT_POS_Y = 10522,
    WALK_FAST_FOOT_POS_Z = 10523,
    WALK_FAST_FOOT_DIR_X = 10524,
    WALK_FAST_FOOT_DIR_Y = 10525,
    WALK_HIP_ROT_X  = 10526,
    WALK_FOOT_POS_L   = 10527,
    WALK_FOOT_DIR_L   = 10528,
    AMPLITUDE_FOOT_POS  = 10529,
    AMPLITUDE_FOOT_DIR  = 10530,
    WALK_FOOT_POS_R   = 10531,
    WALK_FOOT_DIR_R   = 10532,
    STAIR_UP_FOOT_POS_Y = 10533,
    STAIR_UP_FOOT_POS_Z = 10534,
    AMPLITUDE_FOOT_POS_STAIR_UP = 10535,
    STAIR_UP_HIP_POS_Y = 10537,
    STAIR_CLIMBING_MORPH = 10538,
    ESCALATOR   = 10539,
    STAIR_UP_HIP_DIR_Y = 10540,
    STAIR_DOWN_FOOT_POS_Y = 10542,
    STAIR_DOWN_FOOT_POS_Z = 10543,
    STAIR_DOWN_HIP_POS_Y = 10544,
    DELTA_HIP = 10545,
    WALK_SLOW_TOES_POS_Y = 10546,
    WALK_FAST_TOES_POS_Y = 10547,
    STAIR_UP_TOES_POS_Y = 10548,
    STAIR_DOWN_TOES_POS_Y = 10549,
    WALK_TOES_L_POS_Y = 10550,
    WALK_TOES_R_POS_Y = 10551,
    WALK_SLOW_CHEST_POS_X = 10552,
    WALK_FAST_CHEST_POS_X = 10554,
    STAIR_UP_CHEST_POS_Z = 10556,
    MIRRORED_FEET_OFFSET = 10557,

    AMPLITUDE_CHEST_POS = 10558,
    WALK_CHEST_POS = 10559,
    WALK_SLOW_CHEST_ROT_Y = 10560,
    WALK_SLOW_CHEST_ROT_X = 10561,
    WALK_FAST_CHEST_ROT_Y = 10562,
    WALK_FAST_CHEST_ROT_X = 10563,
    STAIR_UP_CHEST_ROT_Y = 10564,
    STAIR_UP_CHEST_ROT_X = 10565,
    STAIR_DOWN_CHEST_ROT_Y = 10566,
    STAIR_DOWN_CHEST_ROT_X = 10567,
    WALK_CHEST_ROT = 10568,
    AMPLITUDE_CHEST_ROT = 10569,
    STAIR_UP_SPINE_POS_Z = 10572,
    
    WALK_CHEST_ROT_X = 10573,
    
    WALK_SPINE_POS = 10574,
    DELTA_ELLBOW_POS = 10575,
    AMPLITUDE_ELLBOW_SWING = 10576,
    WALK_SLOW_ELLBOW_POS_Z = 10577,
    WALK_FAST_ELLBOW_POS_Z = 10578,
    WALK_SLOW_ELLBOW_DIRECTION_POS_X = 10579,
    WALK_FAST_ELLBOW_DIRECTION_POS_X = 10580,
    WALK_ELLBOW_L_POS = 10581,
    WALK_ELLBOW_R_POS = 10582,
    WALK_ELLBOW_L_TARGET = 10583,
    WALK_ELLBOW_R_TARGET = 10584,
    WALK_SPINE_DIRECTION = 10585,
    
    STILL_ELLBOW_POS = 10600,
    STILL_ELLBOW_TARGET_POS = 10601,
    STILL_WRIST_POS = 10602,
    STILL_WRIST_TARGET_POS = 10603,
    STILL_HAND_TARGET_POS = 10604,
    DELTA_ELLBOW_TARGET_POS = 10605,
    DELTA_WRIST_POS = 10606,
    DELTA_WRIST_TARGET_POS = 10607,
    DELTA_HAND_TARGET_POS = 10608,
    
    WALK_SLOW_WRIST_POS_X = 10609,
    WALK_SLOW_WRIST_POS_Y = 10610,
    WALK_SLOW_WRIST_POS_Z = 10611,

    WALK_FAST_WRIST_POS_Y = 10613,
    WALK_FAST_WRIST_POS_Z = 10614,
    
    WALK_WRIST_L_POS = 10615,
    WALK_WRIST_R_POS = 10616,
    
    WALK_WRIST_DIR_L_POS = 10623,
    WALK_WRIST_DIR_R_POS = 10624,
    
    WALK_SHOULDER_L_POS = 10625,
    WALK_SHOULDER_R_POS = 10626,
    WALK_SLOW_SHOULDER_POS_Z = 10627,
    WALK_FAST_SHOULDER_POS_Z = 10628,
    DELTA_SHOULDER_POS = 10629,
    LEFT_SHOULDER_LOCAL_IN_CHEST = 10630,
    RIGHT_SHOULDER_LOCAL_IN_CHEST = 10631,
    STILL_SHOULDER_POS = 10632,
    
    IDLE_HIP_POS_X  = 10633,
    IDLE_CHEST_DIR_X  = 10634,
    IDLE_HEAD_DIR_X = 10635,
    WALK_HEAD_POS = 10700,
    WALK_HEAD_ROT = 10701,
    WALK_HEAD_END_POS = 10702,
    RELATIVE_HEAD_POS   = 10703,
    RELATIVE_HEAD_END_POS   = 10704,
    RELATIVE_HEAD_ROT   = 10705,
    
    SIT_HAND_DIR = 10706,
    WALK_FAST_HAND_DIR = 10707,
    VORSCHUB_KURVE = 10708,
    
    LPOS_K1 = 10710,
    LPOS_K2 = 10711,
    LPOS_K3 = 10712,
    LPOS_K4 = 10713,
    RELATIVE_L_FINGER_K1 = 10714,
    RELATIVE_L_FINGER_K2 = 10715,
    RELATIVE_L_FINGER_K3 = 10716,
    LPOS_R1 = 10720,
    LPOS_R2 = 10721,
    LPOS_R3 = 10722,
    LPOS_R4 = 10723,
    RELATIVE_L_FINGER_R1 = 10724,
    RELATIVE_L_FINGER_R2 = 10725,
    RELATIVE_L_FINGER_R3 = 10726,
    LPOS_M1 = 10730,
    LPOS_M2 = 10731,
    LPOS_M3 = 10732,
    LPOS_M4 = 10733,
    RELATIVE_L_FINGER_M1 = 10734,
    RELATIVE_L_FINGER_M2 = 10735,
    RELATIVE_L_FINGER_M3 = 10736,
    LPOS_Z1 = 10740,
    LPOS_Z2 = 10741,
    LPOS_Z3 = 10742,
    LPOS_Z4 = 10743,
    RELATIVE_L_FINGER_Z1 = 10744,
    RELATIVE_L_FINGER_Z2 = 10745,
    RELATIVE_L_FINGER_Z3 = 10746,
    LPOS_D1 = 10750,
    LPOS_D2 = 10751,
    LPOS_D3 = 10752,
    LPOS_D4 = 10753,
    RELATIVE_L_FINGER_D1 = 10754,
    RELATIVE_L_FINGER_D2 = 10755,
    RELATIVE_L_FINGER_D3 = 10756,
    
    RPOS_K1 = 10810,
    RPOS_K2 = 10811,
    RPOS_K3 = 10812,
    RPOS_K4 = 10813,
    RELATIVE_R_FINGER_K1 = 10814,
    RELATIVE_R_FINGER_K2 = 10815,
    RELATIVE_R_FINGER_K3 = 10816,
    RPOS_R1 = 10820,
    RPOS_R2 = 10821,
    RPOS_R3 = 10822,
    RPOS_R4 = 10823,
    RELATIVE_R_FINGER_R1 = 10824,
    RELATIVE_R_FINGER_R2 = 10825,
    RELATIVE_R_FINGER_R3 = 10826,
    RPOS_M1 = 10830,
    RPOS_M2 = 10831,
    RPOS_M3 = 10832,
    RPOS_M4 = 10833,
    RELATIVE_R_FINGER_M1 = 10834,
    RELATIVE_R_FINGER_M2 = 10835,
    RELATIVE_R_FINGER_M3 = 10836,
    RPOS_Z1 = 10840,
    RPOS_Z2 = 10841,
    RPOS_Z3 = 10842,
    RPOS_Z4 = 10843,
    RELATIVE_R_FINGER_Z1 = 10844,
    RELATIVE_R_FINGER_Z2 = 10845,
    RELATIVE_R_FINGER_Z3 = 10846,
    RPOS_D1 = 10850,
    RPOS_D2 = 10851,
    RPOS_D3 = 10852,
    RPOS_D4 = 10853,
    RELATIVE_R_FINGER_D1 = 10854,
    RELATIVE_R_FINGER_D2 = 10855,
    RELATIVE_R_FINGER_D3 = 10856,
    
    L_FINGER_K_PARENT = 10900,
    L_FINGER_R_PARENT = 10901,
    L_FINGER_M_PARENT = 10902,
    L_FINGER_Z_PARENT = 10903,
    L_FINGER_D_PARENT = 10904,
    R_FINGER_K_PARENT = 10905,
    R_FINGER_R_PARENT = 10906,
    R_FINGER_M_PARENT = 10907,
    R_FINGER_Z_PARENT = 10908,
    R_FINGER_D_PARENT = 10909,
    
    WALK_L_HAND_DIR = 10910,
    WALK_R_HAND_DIR = 10911,
    WALK_L_HAND_MAT = 10912,
    WALK_R_HAND_MAT = 10913,
    
    D_FINGER1_L = 11000,
    D_FINGER2_L = 11001,
    Z_FINGER1_L = 11002,
    Z_FINGER2_L = 11003,
    M_FINGER1_L = 11004,
    M_FINGER2_L = 11005,
    R_FINGER1_L = 11006,
    R_FINGER2_L = 11007,
    K_FINGER1_L = 11008,
    K_FINGER2_L = 11009,
    
    D_FINGER1_R = 11010,
    D_FINGER2_R = 11011,
    Z_FINGER1_R = 11012,
    Z_FINGER2_R = 11013,
    M_FINGER1_R = 11014,
    M_FINGER2_R = 11015,
    R_FINGER1_R = 11016,
    R_FINGER2_R = 11017,
    K_FINGER1_R = 11018,
    K_FINGER2_R = 11019,
    
    OLDSTEP_L   = 11050,
    OLDSTEP_R   = 11051,
    OLD_POS     = 11052,
    
    IK_HIP          = 11999,
    LEFT_IK_THIGH   = 12000,
    LEFT_IK_SHIN    = 12001,
    LEFT_IK_ANKLE   = 12002,
    LEFT_IK_TOES    = 12003,
    RIGHT_IK_THIGH  = 12010,
    RIGHT_IK_SHIN   = 12011,
    RIGHT_IK_ANKLE  = 12012,
    RIGHT_IK_TOES   = 12013,
    
    SECRET_SPEED    = 12020,
    SECRET_SPEED_SWITCH = 12021,
    SECRET_HEAD_DIRECTION   = 12022,
    SECRET_HEAD_SWITCH      = 12023,
    KURVENPOSITION  = 12024,
    SECRET_STRIDE_SWITCH = 12025,
    SECRET_STRIDE_AMPLITUDE = 12026,
    SECRET_ELEVATOR_SWITCH  = 12027,
    
    SECRET_FOOT_L_IK_SWITCH = 12040,
    SECRET_FOOT_R_IK_SWITCH = 12041,
    SECRET_L_KNEE = 12042,
    SECRET_R_KNEE = 12043,
    SECRET_L_FOOT = 12044,
    SECRET_R_FOOT = 12045,
    SECRET_L_FOOT_MORPH = 12046,
    SECRET_R_FOOT_MORPH = 12047,
    FEET_OFFSET_WALK = 12070,
    FEET_OFFSET_STATIC = 12071,
    
    R_STATIC_HAND_TARGET_HANDRAIL =12999,
    R_STATIC_WRIST_HANDRAIL = 13000,
    R_STATIC_WRIST_TARGET_HANDRAIL = 13001,
    R_STATIC_ELLBOW_HANDRAIL = 13002,
    R_STATIC_ELLBOW_TARGET_HANDRAIL = 13003,
    
    R_STATIC_HANDRAIL_POS = 13004,
    R_STATIC_SECRET_HANDRAIL_POS = 13005,
    R_STATIC_ARM_MORPH = 13006,
    R_STATIC_SECRET_ARM_MORPH = 13007,
    USE_R_SECRET_ARM_MORPH = 13008,
    R_STATIC_HAND_POSITION = 13009,
    R_STATIC_SECRET_HAND_POS = 13010,
    R_STATIC_SHOULDER = 13011,
    
    USE_L_SECRET_ARM_MORPH = 13012,
    L_STATIC_ARM_MORPH = 13013,
    L_STATIC_SECRET_ARM_MORPH = 13014,
    L_STATIC_HAND_POSITION = 13015,
    L_STATIC_SECRET_HAND_POS = 13016,
    L_STATIC_HANDRAIL_POS = 13017,
    L_STATIC_SECRET_HANDRAIL_POS = 13018,
    L_STATIC_SHOULDER = 13019,
    
    R_STATIC_HAND_TARGET_CASE = 13020,
    R_STATIC_WRIST_CASE = 13021,
    R_STATIC_WRIST_TARGET_CASE = 13022,
    R_STATIC_ELLBOW_CASE = 13023,
    R_STATIC_ELLBOW_TARGET_CASE = 13024,
    R_STATIC_CASE_POS = 13025,
    R_STATIC_SECRET_CASE_POS = 13026,
    
    R_STATIC_HAND_TARGET_READ = 13030,
    R_STATIC_WRIST_READ = 13031,
    R_STATIC_WRIST_TARGET_READ = 13032,
    R_STATIC_ELLBOW_READ = 13033,
    R_STATIC_ELLBOW_TARGET_READ = 13034,
    
    R_STATIC_HAND_TARGET_POINT = 13040,
    R_STATIC_WRIST_POINT = 13041,
    R_STATIC_WRIST_TARGET_POINT = 13042,
    R_STATIC_ELLBOW_POINT = 13043,
    R_STATIC_ELLBOW_TARGET_POINT = 13044,
    
    R_STATIC_HAND_TARGET_PHONE = 13050,
    R_STATIC_WRIST_PHONE = 13051,
    R_STATIC_WRIST_TARGET_PHONE = 13052,
    R_STATIC_ELLBOW_PHONE = 13053,
    R_STATIC_ELLBOW_TARGET_PHONE = 13054,
    
    R_STATIC_HAND_TARGET_CASE_B = 13060,
    R_STATIC_WRIST_CASE_B = 13061,
    R_STATIC_WRIST_TARGET_CASE_B = 13062,
    R_STATIC_ELLBOW_CASE_B = 13063,
    R_STATIC_ELLBOW_TARGET_CASE_B = 13064,
    R_STATIC_CASE_MORPH = 13065,
    L_STATIC_CASE_MORPH = 13066,
    
    STUFENHOEHE = 14000,
    STUFENTIEFE = 14001,
    SLIDER_FOOT_POS_X = 14002,
    SLIDER_FOOT_POS_Y = 14003,
    SLIDER_FOOT_POS_Z = 14004,
    SLIDER_HIP_ROT_X = 14005,
    SLIDER_HIP_ROT_Y = 14006,
    SLIDER_HIP_ROT_Z = 14007,
    SLIDER_HIP_POS_X = 14008,
    SLIDER_HIP_POS_Y = 14009,
    SLIDER_HIP_POS_Z = 14010,
    SLIDER_FOOT_ROT_X = 14011,
    SLIDER_FOOT_ROT_Y = 14012,
    SLIDER_ARM_TIME_OFFSET = 14013,
    SLIDER_CHEST_POS_X = 14014,
    SLIDER_TOE_ORIENTATION = 14015,
    SLIDER_CHEST_ROT_X = 14017,
    SLIDER_CHEST_ROT_Y = 14018,
    SLIDER_TIP_TOE = 14019,
    SLIDER_HIP_TIME_OFFSET = 14020,
    PRESET_MALE = 14021,
    PRESET_FEMALE = 14022,
    RIG_PRESET_MENUE = 14023,
    STANDARD_MOCAP_RIG = 0,
    PIM_V1_RIG = 1,
    AUTODESK_RIG_LOW = 2,
    AUTODESK_RIG_HIGH = 3,
    AXYZ_RIG = 4,
    DAZ_RIG = 5,
    DAZ_RIG_2 = 6,
    RENDERPEOPLE = 7,
    FUSE_MIXAMO = 8,
    NEW_RIG = 9,
    POSER_RIG_V = 10,
    POSER_RIG_M = 11,
    BUTTON_LOAD_RIG = 14024,
    UEBER_MAT_OFFSET = 14025,
    DELTA_HIP_ROT = 14026,
    DELTA_CHEST_ROT = 14027,
    HEAD_TARGET_POINT = 14028,
    SECRET_AXYZ_HIP = 14029,
    LOCAL_AXYZ_HIP_MAT = 14030,
    SLIDER_FOOT_DIR = 14031,
    DELTA_CHEST_POS = 14032,
    SLIDER_HEAD_TO_NECK = 14033,
    SLIDER_HEAD_TO_CHEST = 14034,
    
    SYNC_JOINTS = 14040,
    
    R_STATIC_HAND_TARGET_HANDRAIL2 =14999,
    R_STATIC_WRIST_HANDRAIL2 = 15000,
    R_STATIC_WRIST_TARGET_HANDRAIL2 = 15001,
    R_STATIC_ELLBOW_HANDRAIL2 = 15002,
    R_STATIC_ELLBOW_TARGET_HANDRAIL2 = 15003,
    
    R_STATIC_HAND_TARGET_CASE2 = 15020,
    R_STATIC_WRIST_CASE2 = 15021,
    R_STATIC_WRIST_TARGET_CASE2 = 15022,
    R_STATIC_ELLBOW_CASE2 = 15023,
    R_STATIC_ELLBOW_TARGET_CASE2 = 15024,
    
    R_STATIC_HAND_TARGET_READ2 =15025,
    R_STATIC_HAND_TARGET_POINT2 =15026,
    
    R_STATIC_HAND_TARGET_PHONE2 = 15050,
    R_STATIC_WRIST_PHONE2 = 15051,
    R_STATIC_WRIST_TARGET_PHONE2 = 15052,
    R_STATIC_ELLBOW_PHONE2 = 15053,
    R_STATIC_ELLBOW_TARGET_PHONE2 = 15054,
    
    R_STATIC_HAND_TARGET_CASE_B2 = 15060,
    R_STATIC_WRIST_CASE_B2 = 15061,
    R_STATIC_WRIST_TARGET_CASE_B2 = 15062,
    R_STATIC_ELLBOW_CASE_B2 = 15063,
    R_STATIC_ELLBOW_TARGET_CASE_B2 = 15064,
    
    DUMMY_LEFT = 16000,
    DUMMY_RIGHT = 16001,
    ABSOLVIERT = 16002,
    
    SPEICHER_HIP = 17000,
    SPEICHER_LOW_SPINE = 17001,
    SPEICHER_UP_SPINE = 17002,
    SPEICHER_CHEST = 17003,
    SPEICHER_NECK = 17004,
    SPEICHER_HEAD = 17005,
    SPEICHER_HEAD_END = 17006,
    SPEICHER_L_THIGH = 17007,
    SPEICHER_L_KNEE = 17008,
    SPEICHER_L_FOOT = 17009,
    SPEICHER_L_TOES = 17010,
    SPEICHER_L_TOES_END = 17011,
    SPEICHER_R_THIGH = 17012,
    SPEICHER_R_KNEE = 17013,
    SPEICHER_R_FOOT = 17014,
    SPEICHER_R_TOES = 17015,
    SPEICHER_R_TOES_END = 17016,
    SPEICHER_L_COLLAR = 17017,
    SPEICHER_L_SHOULDER = 17018,
    SPEICHER_DUMMY1 = 17019,
    SPEICHER_L_FOREARM = 17020,
    SPEICHER_L_FOREARM_ROT = 17021,
    SPEICHER_L_WRIST = 17022,
    SPEICHER_L_HAND_END = 17023,
    SPEICHER_L_KLEIN1 = 17024,
    SPEICHER_L_KLEIN2 = 17025,
    SPEICHER_L_KLEIN3 = 17026,
    SPEICHER_L_RING1 = 17027,
    SPEICHER_L_RING2 = 17028,
    SPEICHER_L_RING3 = 17029,
    SPEICHER_L_MITTE1 = 17030,
    SPEICHER_L_MITTE2 = 17031,
    SPEICHER_L_MITTE3 = 17032,
    SPEICHER_L_ZEIGE1 = 17033,
    SPEICHER_L_ZEIGE2 = 17034,
    SPEICHER_L_ZEIGE3 = 17035,
    SPEICHER_L_DAUMEN1 = 17036,
    SPEICHER_L_DAUMEN2 = 17037,
    SPEICHER_L_DAUMEN3 = 17038,
    SPEICHER_R_COLLAR = 17039,
    SPEICHER_R_SHOULDER = 17040,
    SPEICHER_DUMMY2 = 17041,
    SPEICHER_R_FOREARM = 17042,
    SPEICHER_R_FOREARM_ROT = 17043,
    SPEICHER_R_WRIST = 17044,
    SPEICHER_R_HAND_END = 17045,
    SPEICHER_R_KLEIN1 = 17046,
    SPEICHER_R_KLEIN2 = 17047,
    SPEICHER_R_KLEIN3 = 17048,
    SPEICHER_R_RING1 = 17049,
    SPEICHER_R_RING2 = 17050,
    SPEICHER_R_RING3 = 17051,
    SPEICHER_R_MITTE1 = 17052,
    SPEICHER_R_MITTE2 = 17053,
    SPEICHER_R_MITTE3 = 17054,
    SPEICHER_R_ZEIGE1 = 17055,
    SPEICHER_R_ZEIGE2 = 17056,
    SPEICHER_R_ZEIGE3 = 17057,
    SPEICHER_R_DAUMEN1 = 17058,
    SPEICHER_R_DAUMEN2 = 17059,
    SPEICHER_R_DAUMEN3 = 17060,
    SPEICHER_PIVOT = 17061,
    
    EXPORT_SETUPWERTE = 18000,
    IMPORT_SETUPWERTE = 18001,
    EXPORT_WALKDESIGNER = 18002,
    IMPORT_WALKDESIGNER = 18003
    
};

#endif
